package gov.va.med.mhv.rxrefill.converter;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.data.converter.PatientRegistryChangeConverter;
import gov.va.med.mhv.rxrefill.data.model.PharmPatientChange;
import gov.va.med.mhv.rxrefill.dto.PharmPatientChangeDTO;

@Component
public class PharmPatientChangeConverter {

	@Autowired
	private PharmacyPatientConverter pharmacyPatientConverter;
	
	@Autowired
	private PatientRegistryChangeConverter patientRegistryChangeConverter;
	
	public PharmPatientChangeDTO convertDomainPharmPatientChange(PharmPatientChange pharmPatientChange){
		PharmPatientChangeDTO pharmPatientChangeDto = new PharmPatientChangeDTO();
		
		pharmPatientChangeDto.setId(pharmPatientChange.getId());
		pharmPatientChangeDto.setOplock(pharmPatientChange.getOplock());
		pharmPatientChangeDto.setPharmPatientId(pharmPatientChange.getPharmPatientId());
		/*
		if (null != pharmPatientChange.getParentPharmacyPatient()) {
			pharmPatientChangeDto.setParentPharmacyPatient(pharmacyPatientConverter.convertDomainPharmacyPatient(pharmPatientChange.getParentPharmacyPatient()));
		}*/
		
		pharmPatientChangeDto.setPatientRegistryChangeId(pharmPatientChange.getPatientRegistryChangeId());
		
		if (null != pharmPatientChange.getPatientRegistryChange()) {
			pharmPatientChangeDto.setPatientRegistryChange(patientRegistryChangeConverter.convertDomainPatientRegistryChange(pharmPatientChange.getPatientRegistryChange()));
		}
		
		return pharmPatientChangeDto;
	}
	
	
	public PharmPatientChange convertDTOPharmPatientChange(PharmPatientChangeDTO pharmPatientChangeDto){
		PharmPatientChange pharmPatientChange = new PharmPatientChange();
		
		pharmPatientChange.setId(pharmPatientChangeDto.getId());
		pharmPatientChange.setOplock(pharmPatientChangeDto.getOplock());
		pharmPatientChange.setPharmPatientId(pharmPatientChangeDto.getPharmPatientId());
		if (null != pharmPatientChangeDto.getParentPharmacyPatient()) {
			pharmPatientChange.setParentPharmacyPatient(pharmacyPatientConverter.convertDTOPharmacyPatient(pharmPatientChangeDto.getParentPharmacyPatient()));
		}
		
		pharmPatientChange.setPatientRegistryChangeId(pharmPatientChangeDto.getPatientRegistryChangeId());
		
		if (null != pharmPatientChangeDto.getPatientRegistryChange()) {
			pharmPatientChange.setPatientRegistryChange(patientRegistryChangeConverter.convertDTOPatientRegistryChange(pharmPatientChangeDto.getPatientRegistryChange()));
		}
		
		return pharmPatientChange;
	}
}
